# 404 Hatası Çözümü - Hızlı Rehber

## ❌ Problem
`install.php` dosyasına erişirken 404 hatası alıyorsunuz.

## ✅ Çözüm Adımları

### 1. Dosyaları Güncelleyin

Şu dosyaları sunucuya yeniden yükleyin:
- ✅ `public/index.php` (güncellendi)
- ✅ `public/.htaccess` (güncellendi)
- ✅ `public/install.php` (zaten var)

### 2. Dosya Konumunu Kontrol Edin

`install.php` dosyası **mutlaka** `public/` klasöründe olmalı:

```
public/
  ├── install.php  ← BURADA
  ├── index.php
  └── .htaccess
```

### 3. İki Yöntemle Erişebilirsiniz

#### Yöntem 1: Direkt URL
```
https://yourdomain.com/install.php
```

#### Yöntem 2: Ana Sayfa (ÖNERİLEN)
```
https://yourdomain.com/
```

Ana sayfaya gittiğinizde, eğer kurulum yapılmamışsa otomatik olarak kurulum sayfası açılacaktır.

## 🔍 Kontrol Listesi

- [ ] `install.php` dosyası `public/` klasöründe
- [ ] `index.php` güncel versiyon yüklendi
- [ ] `.htaccess` güncel versiyon yüklendi
- [ ] `vendor/` klasörü yüklendi
- [ ] PHP versiyonu 8.1+

## 🆘 Hala Çalışmıyorsa

### Alternatif: Manuel Kurulum

1. **.env dosyası oluştur** (public klasörünün bir üst dizininde)
2. **APP_KEY oluştur** (online tool ile)
3. **phpMyAdmin'den SQL dosyasını içe aktar** (`database/ticket_system.sql`)
4. **Storage klasörü oluştur**

Detaylar için: `KURULUM_SORUN_GIDERME.md` dosyasına bakın.

## ✅ Başarı Kontrolü

Kurulum başarılıysa:
- Ana sayfa açılmalı
- Admin paneline giriş yapabilmelisiniz
- `install.php` artık çalışmamalı (güvenlik için silin)

Başarılar! 🚀

